;;; -*- Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Base:10; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1; *Patch-File:T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987 Texas Instruments Incorporated. All rights reserved.*
;1;; Copyright (C) 1984-1989 Texas Instruments Incorporated. All rights reserved.*
;1;; Copyright (c) 1980 Massachusetts Institute of Technology *


;; Trace package
;1---------------------------------------------------------------------------------*
;;	"There is always a place for debugging.  No matter how
;;	 hard you try to think of everything in advance, you
;;	 will always find that there is something else that you
;;	 hadn't thought of."
;;			- My Life as a Mathematician
;;			  by Hfpsh Dboups
;;; Items in this menu are lists of the form:
;;;  ("name" :VALUE (S-expr-arg-p . what-to-append-into-trace-options))
;;;			^-- if this is UNTRACE, QUIT, or DO-IT, that
;;;                         special function.
;;;			if NIL, nothing special.
;;;			otherwise is prompt for reading what goes into
;;;                         trace options.
;;; Try to keep this so it comes out in 3 columns.
;1---------------------------------------------------------------------------------*

tv:
(DEFVAR 4trace-item-list*
   '(("3Break before*" :value (nil :break t) 
      :documentation "3Call BREAK before entering the function, binding ARGLIST.*")
     ("3Break after*" :value (nil :exitbreak t) 
      :documentation "3Call BREAK after leaving the function, binding VALUES.*")
     ("3Step*" :value (nil :step) 
      :documentation "3Single-step through the body of the (interpreted) function.*")
     ("3Cond Step*" :value ("3Predicate for stepping calls*" :stepcond) 
      :documentation "3Asks for a predicate which controls whether stepping happens.*")
     ("3Error*" :value (nil :error) 
      :documentation "3Enter the error handler's debugger when the function is called.*")
     ("3Print*" :value ("3Form to evaluate and print in trace messages*" :print) 
      :documentation "3Asks for a form to be evaluated and printed in trace messages.*")
     ("3Print before*" :value ("3Form to evaluate and print before calling*" :entryprint)
      :documentation "3Asks for a form to be evaluated and printed upon function entry.*")
     ("3Print after*" :value ("3Form to evaluate and print after returning*" :exitprint)
      :documentation "3Asks for a form to be evaluated and printed upon function exit.*")
     ("3Conditional*" :value ("3Predicate for tracing*" :cond) 
      :documentation "3Asks for a predicate which controls whether tracing happens.*")
     ("3Cond before*" :value ("3Predicate for tracing calls*" :entrycond) 
      :documentation "3Asks for a predicate which controls tracing of function entry.*")
     ("3Cond after*" :value ("3Predicate for tracing returns*" :exitcond) 
      :documentation "3Asks for a predicate which controls tracing of function exit.*")
     ("3Cond break before*" :value ("3Predicate for breaking before*" :break) 
      :documentation "3Asks for a predicate which controls BREAKing on function entry.*")
     ("3Cond break after*" :value ("3Predicate for breaking after*" :exitbreak) 
      :documentation "3Asks for a predicate which controls BREAKing on function exit.*")
     ("3ARGPDL*" :value ("3Arg pdl variable*" :argpdl) 
      :documentation "3Asks for a variable which gets list of recursive argument lists.*")
     ("3Wherein*" :value ("3Function within which to trace*" :wherein) 
      :documentation "3Asks for a function, within which tracing will be active.*")
     ("3Untrace*" :value (UNTRACE) :font :menu-standout 
      :documentation "3Instead of tracing this function, stop tracing it.*")
     ("3Abort*" :value (quit) :font :menu-standout 
      :documentation "3Click here to get out of this without doing anything.*")
     ("3Do It*" :value (do-it) :font :menu-standout 
      :documentation "3Click here to do the tracing with the selected options.*"))) 

tv:
(DEFWINDOW-RESOURCE 4trace-pop-up-menu* () :make-window
   (dynamic-temporary-menu
     :name "3Trace Options*"
     :item-list-pointer 'trace-item-list)
   :reusable-when :deexposed) 

tv:
(DEFUN 4trace-via-menus* (&optional fcn)
  "2This function is invoked in the momentary menu process when the
user clicks TRACE and in the editor process by the editor's Trace
command.  If the function isn't supplied as an argument the user is
asked for it.*"
  (USING-RESOURCE (trace-pop-up-window pop-up-text-window)
     (USING-RESOURCE (trace-pop-up-menu trace-pop-up-menu)
	(FUNCALL trace-pop-up-window :set-label "3Trace*")
	(FUNCALL trace-pop-up-window :set-size
		 (MIN 1000			;1Accomadate small mac screens  PMH 3/11*
		      (tv:sheet-width (tv:sheet-superior trace-pop-up-window))) 
		 (MIN 300			;1Accomadate small mac screens  PMH 3/11*
		      (FLOOR (tv:sheet-height (tv:sheet-superior trace-pop-up-window)) 2)))
	(FUNCALL trace-pop-up-window :center-around mouse-x mouse-y)
	(window-call (trace-pop-up-window :deactivate)
	 (UNWIND-PROTECT (LET
			  ((blinker (CAR (sheet-blinker-list trace-pop-up-window))))
			  (COND
			    ((NULL fcn)
			     ;1; Make sure blinker is blinking.*
			     (blinker-set-visibility blinker :blink)
			     (FORMAT trace-pop-up-window
				     "3Type in name of function to be traced or untraced.
  Abort quits.~%*")
			     (DO ((*terminal-io* trace-pop-up-window)
				  (*standard-input* trace-pop-up-window)
				  (*standard-output* trace-pop-up-window))
				 (nil)
			       (SETQ fcn (READ))
                               (SETQ fcn (dwimify-arg-package fcn 'function-spec))     ;1!*
			       (IF (FDEFINEDP fcn)
				 (RETURN ())
				 (FORMAT t "3 ;not a defined function, try again~%*")))))
			  (FUNCALL trace-pop-up-menu :move-near-window trace-pop-up-window)
			  (DO ((form (IF (ATOM fcn)
				       `(TRACE (,fcn))
				       `(TRACE (:function ,fcn))))
			       (choice)
			       (option)
			       (arg))
			      (nil)
			       ;1; Put the current status on the text window.*
			    (FUNCALL trace-pop-up-window :clear-screen)
			    ;1; 76 is width in characters.*
			    (GRIND-TOP-LEVEL form 76 trace-pop-up-window)
			    ;1; Not listening to the keyboard any more, shut off blinker.*
			    (blinker-set-visibility blinker nil)
			    ;1; Get input from the menu.*
			    (SETQ choice (FUNCALL trace-pop-up-menu :choose)
				  option (FIRST choice))
			    (COND
			      ((NULL choice))            ;1Try again if outside menu*
			      ((EQ option 'UNTRACE) (EVAL `(UNTRACE ,fcn)) (RETURN ()))
			      ((EQ option 'quit) (RETURN ()))
			      ((EQ option 'do-it) (EVAL form) (RETURN ()))
			      (t
			       ;1; let's make it smarter so that we can undo choices.*
			       (LET ((previous-entry-position
				      (POSITION (SECOND choice) (THE list (SECOND form)) :test
						#'EQ)))
				 (COND
				   ((AND previous-entry-position
				       (OR (EQ (SECOND choice) :break)
					  (EQ (SECOND choice) :exitbreak))
				       (CDDR choice))
				    ;1; Then we should either remove it from*
				    ;1; the list if it is the same or just*
				    ;1; change the argument.*
				    (IF (EQ (THIRD choice)
					 (NTH (1+ previous-entry-position) (SECOND form)))
				     ;1; Remove the choice*
				      (IF (EQ previous-entry-position 0)
					(SETF (SECOND form) (CDDR (SECOND form)))
					;1; ELSE*
					(SETF (NTHCDR previous-entry-position (SECOND form))
					      (NTHCDR (+ 2 previous-entry-position)
						      (SECOND form))))
				      ;1; ELSE*
				      ;1; Fix the choice*
				      (SETF (NTH (1+ previous-entry-position) (SECOND form))
					    (THIRD choice))))
				   ((AND previous-entry-position (NULL option))
				    ;1; Delete the choice.*
				    (IF (EQ previous-entry-position 0)
				      (SETF (SECOND form) (CDR (SECOND form)))
				      (SETF (NTHCDR previous-entry-position (SECOND form))
					    (NTHCDR (1+ previous-entry-position) (SECOND form)))))
				   ((NULL option)
				    ;1; Just add the object.*
				    (SETF (SECOND form) (APPEND (SECOND form) (CDR choice))))
				   (t
				    ;1; Needs an arg, get it.*
				    (FORMAT trace-pop-up-window "3~2%~A:~%*" option)
				    ;1; Turn on blinker.*
				    (blinker-set-visibility blinker :blink)
				    (LET ((*terminal-io* trace-pop-up-window)
					  (*standard-input* trace-pop-up-window)
					  (*standard-output* trace-pop-up-window)
					  (flag))
				      (MULTIPLE-VALUE-SETQ (arg flag)
					(FUNCALL *terminal-io* :rubout-handler
						 '((:full-rubout :full-rubout))
						 #'READ-FOR-TOP-LEVEL))
				      (UNLESS flag
				       ;1; If previous entry replace the argument*
				       ;1; otherwise add on new argument.*
					(IF (NULL previous-entry-position)
					  (SETF (SECOND form)
						(APPEND (SECOND form) (CDR choice) (CONS arg ())))
					  (SETF (NTH (1+ previous-entry-position) (SECOND form))
						arg)))))))))))
	   (FUNCALL trace-pop-up-menu :deactivate)))))) 


;1tv:*
;1(ADD-TO-SYSTEM-MENU-COLUMN :DEBUG "Trace" '(TRACE-VIA-MENUS)*
;			1   "Trace a function.  Options selected from menu."*
;			1   :SORTED)
